from django.urls import path
from .views import *
from . import views
from users.views import CustomLoginView

urlpatterns = [
    path('', home, name='whm_home'),
    path('profile_all/', profile_all, name='whm-profile'),
    path('whm_logout/', whm_logout, name='whm_logout'),
    path('system_status/', system_status, name='system_status'),
    path('domain_list_all/', domain_list_all, name='domain_list_all'),
    path('domain_list_ssl_all/', domain_list_ssl_all, name='domain_list_ssl_all'),
    path('add_domain/', add_domain, name='add_domain'),
    path('dns_all/', dns_all, name='dns_all'),
    path('dns_all/list/<int:rid>/', dns_list_all, name='dns_list_all'),
    path('dns_all/edit/<int:rid>/', dns_edit_all, name='dns_edit_all'),
    path('dns_all/delete/<int:rid>/', dns_delete_all, name='dns_delete_all'),
    path('dns_all/create/', dns_create_all, name='dns_create_all'),
    path('dns_all/create/<int:domain_id>/', dns_create_all, name='dns_create_with_id_all'),
    path('domains_all/delete/<int:pk>/', domain_delete_all, name='domain_delete_all'),
    path('domains_all/edit/<int:pk>/', domain_edit_all, name='domain_edit_all'),
    path('user_list_all/', user_list_all, name='user_list_all'),
    path('add_user_all/', add_user_all, name='add_user_all'),
    path('package_list/', package_list, name='package_list'),
    path('new_package/', new_package, name='new_package'),
    path('update_package/<int:rid>/', update_package, name='update_package'),
    path('update_user/<int:rid>/', update_user, name='update_user'),
    path('suspend_user/<int:rid>/', suspend_user, name='suspend_user'),
    path('whm-password-change/', change_password_all, name='whm_password_change'),
    path('multi_php_manager_all/', multi_php_manager_all, name='multi_php_manager_all'),
    path('multi_php_ini/', multi_php_ini, name='multi_php_ini'),
    path('fetch_php_settings/', fetch_php_settings, name='fetch_php_settings'),
    path('ini_editor/', ini_editor, name='ini_editor'),
    path('php_ext/', php_ext, name='php_ext'),
    path('php_ext_load/', php_ext_load, name='php_ext_load'),
    path('php_versions/', php_versions, name='php_versions'),
    path('php_install_now/', php_install_now, name='php_install_now'),
    path('services/', services, name='services'),
    path('service/<str:service_name>/<str:action>/', service_action, name='service_action'),
    path('process_manager/', process_manager, name='process_manager'),
    path('kill_process/', kill_process, name='kill_process'),
    path('reboot/', reboot, name='reboot'),
    path('reboot_view/', reboot_view, name='reboot_server'),
    path('email_queue/', email_queue, name='email_queue'),
    path('configserver/', configserver, name='configserver'),
    path('csf_install/', csf_install, name='csf_install'),
    path('mod_install/', mod_install, name='mod_install'),
    path('mode_sec/', mode_sec, name='mode_sec'),
    path('iframe/', configservercsfiframe, name='configservercsfiframe'),
    path('firewall_port/', firewall_port, name='firewall_port'),
    path('panel_port/', panel_port, name='panel_port'),
    path('ssh_port/', ssh_port, name='ssh_port'),
    path('time_zone/', time_zone, name='time_zone'),
    path('phpmyadmins/', phpmyadmin_view_admin, name='phpmyadmins'),
    path('auto_login/<int:rid>/', auto_login_by_admin, name='auto_login'),
    path('panel_ssl/', panel_ssl, name='panel_ssl'),
    path('backup_whm/', backup_whm, name='backup_whm'),
    path('backup_delete_whm/<int:id>/', backup_delete_whm, name='backup_delete_whm'),
    path('backup_restore/', backup_restore, name='backup_restore'),
    path('backup_restore_start/', backup_restore_start, name='backup_restore_start'),
    path("panel_ssl_update/", panel_ssl_update, name="panel_ssl_update"),
    path('list-backup-files/', list_backup_files, name='list_backup_files'),
    path('domain_list_ssl_first_all/<int:pk>/', domain_list_ssl_first_all, name='domain_list_ssl_first_all'),
    path('update_check/', update_check, name='update_check'),
    path('install_update/', install_update, name='install_update'),
    path('account_details/<int:id>/', account_details, name='account_details'),
    path('olsapp_whm/', olsapp_whm, name='olsapp_whm'),
    path('install_olsapp/', install_olsapp, name='install_olsapp'),
    path('install_softaculous_pkg/', install_softaculous_pkg, name='install_softaculous_pkg'),
    path('change_hostname/', change_hostname_view, name='change_hostname'),
    path('system_status_view/', system_status_view, name='system_status_view'),
    path('litespeed_conf/', litespeed_conf, name='litespeed_conf'),
    path('fatch_php_tune/', fatch_php_tune, name='fatch_php_tune'),
    path('php_tune/', php_tune, name='php_tune'),
    path('domain_preview_whm/<int:rid>/', domain_preview_whm, name='domain_preview_whm'),
    path('php_error_whm/', php_error_whm, name='php_error_whm'),
    path('fatch_php_error_whm/', fatch_php_error_whm, name='fatch_php_error_whm'),
    path('php_ext_manage/', php_ext_manage, name='php_ext_manage'),
    path('settings/', panel_settings, name='settings'),
    path('csf_remove/', csf_remove, name='csf_remove'),
    path('ufw/', ufw, name='ufw'),
    path('node_versions/', node_versions, name='node_versions'),
    path('node_install_now/', node_install_now, name='node_install_now'),
    path('node_module_manage/', node_module_manage, name='node_module_manage'),
    path('node_module_load/', node_module_load, name='node_module_load'),
    path('imunifyfav_whm/', imunifyfav_whm, name='imunifyfav_whm'),
    path('install_imunifyfav/', install_imunifyfav, name='install_imunifyfav'),
    path('composer_whm/', composer_whm, name='composer_whm'),
    path('install_composer/', install_composer, name='install_composer'),
    
   
   
]
