from django.urls import path
from .views import *
from . import views
urlpatterns = [
    path('', home, name='users-home'),
    path('profile/', profile, name='users-profile'),
    path('domain/', domain, name='users-domain'),
    path('domain_list/', domain_list, name='domain_list'),
    path('domain_list_ssl/', domain_list_ssl, name='domain_list_ssl'),
    path('domain_list_ssl_first/<int:pk>/', domain_list_ssl_first, name='domain_list_ssl_first'),
    path('multi_php_manager/', multi_php_manager, name='multi_php_manager'),
    path('domains/delete/<int:pk>/', views.domain_delete, name='domain_delete'),
    path('domains/edit/<int:pk>/', views.domain_edit, name='domain_edit'),
    path('db_make/', db_make, name='db_make'),
    path('db_user_make/<str:db>/', db_user_make, name='db_user_make'),
    path('database_list/', database_list, name='database_list'),
    path('database_userlist/', database_userlist, name='database_userlist'),
    path('db_user_edit/<str:db>/', db_user_edit, name='db_user_edit'),
    path('db_edit/<str:db>/', db_edit, name='db_edit'),
    path('dns/', dns, name='dns'),
    path('dns/list/<int:rid>/', dns_list, name='dns_list'),
    path('dns/edit/<int:rid>/', dns_edit, name='dns_edit'),
    path('dns/delete/<int:rid>/', dns_delete, name='dns_delete'),
    path('dns/create/', dns_create, name='dns_create'),
    path('dns/create/<int:domain_id>/', dns_create, name='dns_create_with_id'),
    path('statics/', statics, name='statics'),
    path('fetch_statics_data/', fetch_statics_data, name='fetch_statics_data'),
    path('email_accounts/', email_accounts, name='email_accounts'),
    path('email_accounts_create/', email_accounts_create, name='email_accounts_create'),
    path('email_forword/', email_forword, name='email_forword'),
    path('email_edit/<int:email_id>/', email_edit, name='email_edit'),
    path('email_forword_list/', email_forword_list, name='email_forword_list'),
    path('email_forword_delete/<int:email_id>/', email_forword_delete, name='email_forword_delete'),
    path('email_delete/<int:email_id>/', email_delete, name='email_delete'),
    path('email_pipe/', email_pipe, name='email_pipe'),
    path('ftp_list/', ftp_list, name='ftp_list'),
    path('ftp_new/', ftp_new, name='ftp_new'),
    path('ftp_delete/<int:ftp_id>/', ftp_delete, name='ftp_delete'),
    path('ftp_edit/<int:ftp_id>/', ftp_edit, name='ftp_edit'),
    path('email_pipe_list/', email_pipe_list, name='email_pipe_list'),
    path('email_pipe_delete/<int:email_id>/', email_pipe_delete, name='email_pipe_delete'),
    path('cronjob_list/', cronjob_list, name='cronjob_list'),
    path('cronjob_add/', cronjob_add, name='cronjob_add'),
    path('cronjob_edit/<int:line>/', cronjob_edit, name='cronjob_edit'),
    path('cronjob_delete/<int:line>/', cronjob_delete, name='cronjob_delete'), 
    path('visitor_list/', visitor_list, name='visitor_list'),
    path('visitor_view/<int:id>/', visitor_view, name='visitor_view'),
    path('db_import/<str:db>/', db_import, name='db_import'),
    path('database_list_import/<str:db>/', database_list, name='database_list_import'),
    path('db_repair/<str:db>/', db_repair, name='db_repair'),
    path('bandth/', bandth, name='bandth'),
    path('backup/', backup, name='backup'),
    path('new_backup/', new_backup, name='new_backup'),
    path('backup_delete/<int:id>/', backup_delete, name='backup_delete'),
    path('backup_now/', backup_now, name='backup_now'),
    path('backup_list/<int:id>/', backup_list, name='backup_list'),
    path('backup_list/', backup_list, name='backup_lists'),
    path('phpmyadmin_view/', phpmyadmin_view, name='phpmyadmin'),
    path('webmail/', webmail, name='webmail'),
    path('password-change/', change_password, name='password_change'),
    path('app_install/<str:name>/', app_install, name='app_install'),
    path('app_install_view/<str:name>/', app_install_view, name='app_install_view'),
    path('default_email/', default_email, name='default_email'),
    path('default_email_list/', default_email_list, name='default_email_list'),
    path('default_email_delete/<int:email_id>/', default_email_delete, name='default_email_delete'),
    path('softaculous_view/', softaculous_view, name='softaculous_view'),
    path('olsapp_view/', olsapp_view, name='olsapp_view'),
    path('sub_domain/', sub_domain, name='sub_domain'),
    path('domain_preview/<int:rid>/', domain_preview, name='domain_preview'),
    path('php_error/', php_error, name='php_error'),
    path('fatch_php_error/', fatch_php_error, name='fatch_php_error'),
    path('custom_ssl/', custom_ssl, name='custom_ssl'),
    path('fatch_custom_ssl/', fatch_custom_ssl, name='fatch_custom_ssl'),
    path('fatch_custom_ssl_info/', fatch_custom_ssl_info, name='fatch_custom_ssl_info'),
    path('multi_php_ini_u/', multi_php_ini_u, name='multi_php_ini_u'),
    path('fatch_php_ini_u/', fatch_php_ini_u, name='fatch_php_ini_u'),
    path('olsapp_more_view/<str:view_name>/', olsapp_more_view, name='olsapp_more_view'),
    path('olsapp_more_view/<str:view_name>/<str:id>/', olsapp_more_view, name='olsapp_more_view_with_id'),
    path('webmail_service/<str:email>/', webmail_service, name='webmail_service'),
    path('backup_settings/', backup_settings, name='backup_settings'),
    path('app_add/<str:name>/', app_add, name='app_add'),
    path('apps_list/<str:type>/', apps_list, name='apps_list'),
    path('app_edit/<str:name>/<int:app_id>/', app_add, name='app_edit'),
    path('restart_node/<int:app_id>/', restart_node_view, name='restart_node'),
    path('install_npm/<int:app_id>/', install_node_npm_view, name='install_npm'),
    path('composer_run/', composer_run, name='composer_run'),
    path('composer/install/run/', composer_install_run, name='composer_install_run'),

]
