from functools import wraps
from django.http import HttpResponseRedirect
from django.shortcuts import redirect
from django.contrib.auth.models import User
from users.database import *  # Import your function

def admincheck(view_func):
    @wraps(view_func)
    def wrapper(request, *args, **kwargs):
        # Check if the user is authenticated
        if not request.user.is_authenticated:
            return HttpResponseRedirect('/login/')
        
        # Check if the user's `whm_group` value is 1
        
        whm = get_user_data_by_id(request.user.id).get('whm')
        if whm == 1:
            return redirect('/whm/')  # Replace with the URL you want to redirect to
        
        return view_func(request, *args, **kwargs)
    return wrapper
